package w83b.w83bDAO;

import w83b.w83bBeans.W83bActasBean;
import w83b.w83bBeans.W83bDelegadoPrevencionBean;
import w83b.w83bBeans.W83bDelegadosBean;





/**
 * The Interface W83bIActasDAO.
 */
public interface W83bIDelegadosPrevencionDAO {
	
	/**
	 * Obtiene el delegado de prevencin de un acta
	 * @param acta W83bActasBean
	 * @param dniDelegado String
	 * @return W83bDelegadoPrevencionBean
	 * @throws Exception exception
	 */
	public W83bDelegadoPrevencionBean obtenerDelegadoPrevencionActa(W83bActasBean acta, String dniDelegado) throws Exception;
	
	/**
	 * Da de baja un delegado de prevencin
	 * @param acta W83bActasBean
	 * @param dniDelegado String
	 * @param fechaBaja String
	 * @throws Exception exception
	 */
	public void updateBajaDelegadoPrevencion(W83bActasBean acta, String dniDelegado, String fechaBaja) throws Exception;
	
	
	/**
	 * Inserta un delegado de prevencin para un acta
	 * @param delegadoPrevencion W83bDelegadosBean
	 * @throws Exception exception
	 */
	public void insertDelegadoPrevencion(W83bDelegadosBean delegadoPrevencion) throws Exception;
	
}
